#!/usr/bin/env bash
chmod +x /usr/local/cpanel/base/frontend/paper_lantern/letsencrypt/get_proxy_names

cd /usr/local/cpanel/base/frontend/paper_lantern/letsencrypt && ./letsencrypt.live.cgi -mode install

# symlink for easy access
ln -sf /usr/local/cpanel/base/frontend/paper_lantern/letsencrypt/letsencrypt.live.cgi /usr/local/bin/le-cp

# we need to restart apache to load in the new autossl exclusion urls the first time
NEEDS_APACHE_RESTART=0
if [ ! -e /var/cpanel/perl/Cpanel/SSL/Auto/Provider/FleetSSLProvider.pm ]; then
	echo "Will rebuild conf and restart Apache to reload AutoSSL DCV URLs"
	NEEDS_APACHE_RESTART=1
fi

# symlink autossl provider
mkdir -p /var/cpanel/perl/Cpanel/SSL/Auto/Provider/
ln -sf /usr/local/cpanel/base/frontend/paper_lantern/letsencrypt/FleetSSLProvider.pm /var/cpanel/perl/Cpanel/SSL/Auto/Provider/FleetSSLProvider.pm

# rebuild httpconf to update new autossl provider and restart apache
if [ $NEEDS_APACHE_RESTART -eq "1" ]; then
	echo "Rebuilding Apache conf and restarting now ..."
	/scripts/rebuildhttpdconf && /scripts/restartsrv_httpd > /dev/null
fi

if rpm -q --quiet letsencrypt-cpanel-0.6.1-1 ; then
	echo -e "\nIf you experience yum errors relating to a previous version of the plugin following this message"
	echo "Then please run the following command, which will take care of it for you:"
	echo -e "\trpm -e --justdb letsencrypt-cpanel-0.6.1-1"
fi
