#!/bin/sh

if [ $# -lt 1 ]; then
	echo "Usage:";
	echo "    $0 alpha"
	echo "    $0 beta"
	echo "    $0 current"
	echo "    $0 stable"
	echo "    $0 [commit-hash]"
	exit 0;
fi

if [ $# -gt 1 ]; then
	shift
fi

CHANNEL=$1
OS_SLUG=linux_amd64
if [ "$(uname)" = "FreeBSD" ]; then
	OS_SLUG=freebsd_amd64
fi

if [ "$(echo -n "${CHANNEL}" | wc -c)" -eq "40" ]; then
	COMMIT="${CHANNEL}"
else
	COMMIT=$(dig +short -t txt "$CHANNEL-version.directadmin.com" | sed 's|.*commit=\([0-9a-f]*\).*|\1|')
fi

if [ -z "${COMMIT}" ]; then
	echo "Error detecting latest DA release"
	exit 1
fi

set -e

FILE="directadmin_${COMMIT}_${OS_SLUG}.tar.gz"
DOWNLOAD_URL="https://download.directadmin.com/${FILE}"
DISTDIR=$(mktemp -d)
cleanup() {
        rm -rf ${DISTDIR}
}
trap cleanup EXIT

curl --location --progress-bar --connect-timeout 10 "${DOWNLOAD_URL}" --output "${DISTDIR}/${FILE}"
tar xzf "${DISTDIR}/${FILE}" -C /usr/local/directadmin
/usr/local/directadmin/directadmin p || true
/usr/local/directadmin/scripts/update.sh
echo 'action=directadmin&value=restart' >> /usr/local/directadmin/data/task.queue

echo "Update Successful."
